/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.TrueCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_167;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.IConditional;
import slimeknights.mantle.client.book.data.IDataItem;
import slimeknights.mantle.client.book.data.JsonCondition;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.content.ContentError;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.BookScreen;

public class SectionData
implements IDataItem,
IConditional {
    public String name = null;
    public ImageData icon = new ImageData();
    public Set<String> requirements = Sets.newHashSet();
    public boolean hideWhenLocked = false;
    public String data = "";
    public JsonCondition condition = new JsonCondition(TrueCondition.ID, new JsonObject());
    public Map<class_2960, JsonElement> extraData = Collections.emptyMap();
    public transient int unnamedPageCounter = 0;
    public transient BookData parent;
    public transient BookRepository source;
    public transient ArrayList<PageData> pages = new ArrayList();

    public SectionData() {
        this(false);
    }

    public SectionData(boolean custom) {
        if (custom) {
            this.data = "no-load";
        }
    }

    public String translate(String string) {
        return this.parent.translate(string);
    }

    @Override
    public void load() {
        String data;
        class_3298 pagesInfo;
        if (this.name == null) {
            this.name = "section" + this.parent.unnamedSectionCounter++;
        }
        this.name = this.name.toLowerCase();
        if (!this.data.equals("no-load") && (pagesInfo = this.source.getResource(this.source.getResourceLocation(this.data))) != null && !(data = this.source.resourceToString(pagesInfo)).isEmpty()) {
            try {
                this.pages = this.getPages(data);
            }
            catch (Exception e) {
                this.pages = new ArrayList();
                PageData pdError = new PageData(true);
                pdError.name = "errorrenous";
                pdError.content = new ContentError("Failed to load section " + this.name + ".", e);
                this.pages.add(pdError);
                e.printStackTrace();
            }
        }
        for (PageData page : this.pages) {
            page.parent = this;
            page.source = this.source;
            page.load();
        }
        this.icon.load(this.source);
    }

    protected ArrayList<PageData> getPages(String data) {
        List<PageData> pages = Arrays.asList((PageData[])BookLoader.getGson().fromJson(data, PageData[].class));
        return pages.stream().filter(PageData::isConditionMet).collect(Collectors.toCollection(ArrayList::new));
    }

    public void update(@Nullable BookScreen.AdvancementCache advancementCache) {
    }

    public String getTitle() {
        String title = this.parent.strings.get(this.name);
        return title == null ? this.name : title;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public boolean isUnlocked(@Nullable BookScreen.AdvancementCache advancementCache) {
        if (advancementCache == null || this.requirements == null || this.requirements.size() == 0) {
            return true;
        }
        for (String achievement : this.requirements) {
            if (SectionData.requirementSatisfied(achievement, advancementCache)) continue;
            return false;
        }
        return true;
    }

    public static boolean requirementSatisfied(String requirement, @Nullable BookScreen.AdvancementCache advancementCache) {
        if (advancementCache == null) {
            return true;
        }
        class_167 progress = advancementCache.getProgress(requirement);
        return progress != null && progress.method_740();
    }

    @Override
    public boolean isConditionMet() {
        return this.condition.test();
    }
}

